//
//  OPMap.h
//  The Obfuscated Path
//
//  Created by ss2cire on 12/8/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "OPTypes.h"

@class OPRoom, OPRoomLayer, OPSprite;
@class OPTrigger;

@interface OPMap : NSObject
{
	NSString			*name;
	NSMutableArray		*rooms;
	OPRoom				*previousRoom;
	OPRoom				*currentRoom;
	OPPoint				currentRoomPoint;
	OPDirection			scrollingDirection;
	BOOL				scrolling;
	
}
- (id)initWithMap:(NSString *)mapName;
- (NSString *)pathToMap;
- (NSString *)getMapResource:(NSString *)resourceName;

- (void)loadMapFile:(NSString *)path; //withEvents:(NSDictionary *)eventList;
- (void)setCurrentRoomAtX:(int)x andY:(int)y;

- (void)draw;
- (void)update;

- (void)setScrolling:(BOOL)value direction:(OPDirection)direction;
- (BOOL)scrolling;

- (void)scroll;

- (NSArray *)triggers;

//assumes the layer the player is on
- (OPSprite *)tileAtX:(int)x andY:(int)y;
- (OPSprite *)tileAtX:(int)x Y:(int)y andLayer:(OPLayer)layer;

- (OPRoom *)currentRoom;

- (NSString *)name;

- (void)enteredRoom;
- (void)exitedRoom;

@end
